<?php
// Handle form submission
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $oldName = trim($_POST['old_name'] ?? '');
    $newName = trim($_POST['new_name'] ?? '');

    if ($oldName && $newName) {
        if (!file_exists($oldName)) {
            $message = "❌ File '$oldName' does not exist.";
        } elseif (file_exists($newName)) {
            $message = "⚠️ A file named '$newName' already exists.";
        } elseif (rename($oldName, $newName)) {
            $message = "✅ File renamed successfully from '$oldName' to '$newName'.";
        } else {
            $message = "❌ Failed to rename the file. Check permissions.";
        }
    } else {
        $message = "⚠️ Both fields are required.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Rename File</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f9f9f9;
            padding: 50px;
        }
        .container {
            max-width: 400px;
            margin: auto;
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 0 12px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #333;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-top: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            background: #007bff;
            color: white;
            padding: 10px;
            width: 100%;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background: #0056b3;
        }
        .message {
            margin-top: 15px;
            text-align: center;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Rename File</h2>
        <form method="POST">
            <label>Current File Name:</label>
            <input type="text" name="old_name" placeholder="e.g. oldfile.html" required>

            <label>New File Name:</label>
            <input type="text" name="new_name" placeholder="e.g. newfile.html" required>

            <input type="submit" value="Rename File">
        </form>
        <?php if ($message): ?>
            <div class="message"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
    </div>
</body>
</html>
